(********************************************************************
 * COPYRIGHT --  
 ********************************************************************
 * Library: MbusTCP
 * File: MbusTCP.fun
 * Author: yangq
 * Created: January 17, 2011
 ********************************************************************
 * Functions and function blocks of library MbusTCP
 ********************************************************************)

FUNCTION_BLOCK MBclient
	VAR_INPUT
		enable : BOOL;
		port : UINT;
		server_ip_addr : STRING[18];
		p_cfg : REFERENCE TO modbus_client_cfg_typ;
		receive_timeout : UDINT;
	END_VAR
	VAR_OUTPUT
		status : UINT;
	END_VAR
	VAR
		step : UINT;
		tcp_open : TcpOpen;
		tcp_client : TcpClient;
		tcp_send : TcpSend;
		tcp_recive : TcpRecv;
		tcp_close : TcpClose;
		last_req : USINT;
		recive_timer : UDINT;
		send_timer : ARRAY[0..19] OF UDINT;
		start_send_time : ARRAY[0..19] OF UDINT;
		start_receive_time : UDINT;
		send_buff : ARRAY[0..255] OF USINT;
		recive_buff : ARRAY[0..255] OF USINT;
		transaction_id : UINT;
		wrong_message : UDINT;
	END_VAR
END_FUNCTION_BLOCK

FUNCTION_BLOCK MBserver
	VAR_INPUT
		ipString : STRING[18];
		enable : BOOL;
		TimeOut : UDINT;
		p_cfg : REFERENCE TO modbus_server_cfg_typ;
	END_VAR
	VAR_OUTPUT
		status : UINT;
	END_VAR
	VAR
		step : UINT;
		client_nr : USINT;
		client_info : ARRAY[0..4] OF client_info_typ;
		client_addr : ARRAY[0..17] OF USINT;
		receive_index : USINT;
		receive_index_old : USINT;
		tcp_open : TcpOpen;
		tcp_server : TcpServer;
		tcp_send : TcpSend;
		tcp_recive_timer : ARRAY[0..4] OF TON_10ms;
		tcp_recive : ARRAY[0..4] OF TcpRecv;
		tcp_close : TcpClose;
		send_buff : ARRAY[0..255] OF USINT;
		exceedMaxClient : BOOL;
		recive_buff : ARRAY[0..4] OF recive_buff_typ;
	END_VAR
END_FUNCTION_BLOCK
